### Test module ####
import random
import math

from demoscript import *

#feg = FileEventGenerator("fart")
#for i in xrange(11):
#	feg.addEvent(d+10.959+i*1.920,"snare")
#	feg.addEvent(10.959+i*1.920,"core_scale")


class RandomTypo(Typo):
  def __init__(self):
    Typo.__init__(self)

  def callback(self):
    if random.random() < 0.1:
      self.reset()
      self.nextPath()



class CurveScene(Scene):

  def __init__(self,sceneName):
    Scene.__init__(self)
    self.sceneProxy=SceneProxy(sceneName)
    self.setScene(self.sceneProxy)
    self.last_i=8
    self.first=1


  def callback(self):
    if getEvent(EC_NOTE_ON,"taptap"):

      meshes=self.getScene().getObjects()

      if self.first==1:
        for i in [8,10,11]:
          meshes[i].curveLength=FixedSlider(0,0)
        self.first=0

      kak=[1,2,3,4,5,6,7,9]
      for k in kak :
        meshes[k].red.setTargetValue(0)
        meshes[k].green.setTargetValue(0)
        meshes[k].blue.setTargetValue(0)


      ints=[8,10,11]
      ints.remove(self.last_i)
      i=random.choice(ints)

      meshes[i].curveLength.setTargetValue(1)
      meshes[i].curveTaper.setTargetValue(.2)
      meshes[i].curveWidth.setTargetValue(1)
      self.last_i=i


    if getEvent(EC_NOTE_ON,"reset1"):     
      self.nextCamera()

#   if getEvent(EC_NOTE_ON,"snare2"):
#     self.reset()


class UtilXMV(XMVPlayer):
  def callback(self):
    if getEvent(EC_NOTE_ON,"snare"):
      self.restart()

class RandomImage(Image):
  def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
    Image.__init__(self,img,0,0)
    self.xpos=xpos
    self.ypos=ypos
    self.xamp=xamp
    self.yamp=yamp

  def setAmpY(self,amp):
    self.yamp=amp

  def setAmpX(self,amp):
    self.xamp=amp

  def callback(self):
    pass

  def revive(self):
    self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
    self.opacity.setTargetValue(1)


class RandomImage2(Image):
  def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
    Image.__init__(self,img,0,0)
    self.xpos=xpos
    self.ypos=ypos
    self.xamp=xamp
    self.yamp=yamp

  def setAmpY(self,amp):
    self.yamp=amp

  def setAmpX(self,amp):
    self.xamp=amp

  def callback(self):
    pass

  def revive(self):
#    self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
    self.opacity = FixedSlider(1,0)
    self.opacity.setDamping(0.98)



class MeneerImage(Image):
  def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
    Image.__init__(self,img,0,0)
    self.xpos=xpos
    self.ypos=ypos
    self.xamp=xamp
    self.yamp=yamp

  def setAmpY(self,amp):
    self.yamp=amp

  def setAmpX(self,amp):
    self.xamp=amp


  def callback(self):
    self.setPos(frand(-0.5,0.5),0)

  def revive(self):
    self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
    self.opacity.setTargetValue(1)


class SimpleImageSeq(ImageSeq):
  def __init__ (self,images=[],nextImage=[],take=0):
    ImageSeq.__init__(self)
    self.nextImageEvents=nextImage
    self.images=images
    for i in self.images:self.addImage(i)
    self.takeAmount=take


  def callback (self):
    for event in self.nextImageEvents:
      if getEvent(EC_NOTE_ON,event):
        if self.takeAmount > 0:
          self.take(self.takeAmount)
        else:
          self.next()


class SimpleXMV(XMVPlayer):
  def __init__(self,name,events=[]):
    XMVPlayer.__init__(self,name)
    self.events=events

  def callback(self):
    for event in events:
      if getEvent(EC_NOTE_ON,event): self.restart()

class SimpleTumCyls(TumCyls):
  def __init__(self,name,events=[]):
    TumCyls.__init__(self,name)
    self.events=events
    self.l = 0;

  def callback(self):

    time = getTime()
    if time < 16:
      self.l = 0.0
    elif time <32:
      self.l *= 0.97

      if getEvent(EC_NOTE_ON,"introflash"):
        self.l = 1.0

      if self.l < 0.2:
        self.l = 0.2

    else:
      self.l = 0.4

    self.setAverageSegmentLength(self.l)





#   if getEvent(EC_NOTE_ON,"introflash"):
#     self.intensity.setTargetValue(1)
#     self.intensity.setDamping(0.99)



class SimpleGamma(RGBMap):
  def __init__(self,events=[],colors=[5,5,5]):
    RGBMap.__init__(self)
    self.events=events
    self.gamma=MGGamma();
    self.gamma.connectOutput(self,"map")
    self.colors=colors
    self.gamma.red.setFixPointDamping(0.97)
    self.gamma.green.setFixPointDamping(0.97)
    self.gamma.blue.setFixPointDamping(0.97)


  def callback(self):
    for event in self.events:
      if getEvent(EC_NOTE_ON,event):
        sg=self.gamma
        for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(i[1])

class HackGamma(RGBMap):
  def __init__(self,events=[],colors=[5,5,5]):
    RGBMap.__init__(self)
    self.events=events
    self.gamma=MGGamma();
    self.gamma.connectOutput(self,"map")
    self.colors=colors
    self.gamma.red.setFixPointDamping(0.97)
    self.gamma.green.setFixPointDamping(0.97)
    self.gamma.blue.setFixPointDamping(0.97)


  def callback(self):
    self.gamma.red = FixedSlider(3,3)
    self.gamma.green = FixedSlider(3,3)
    self.gamma.blue = FixedSlider(3,3)



class SimpleBlur(Blur):
  def __init__(self,events=[],restv=0.0,highv=1.0):
    Blur.__init__(self)
    self.m_events=events
    self.mix=FixedSlider(restv,restv)
    self.highv=highv

  def callback(self):
    for event in self.m_events:
      if getEvent(EC_NOTE_ON,event):
        self.mix.setTargetValue(self.highv)
        self.mix.setFixPointDamping(0.9995)
        self.mix.setDamping(0.97)

class SimpleEdge(Edge):
  def __init__(self,events=[],restv=0.0,highv=1.0):
    Edge.__init__(self)
    self.m_events=events
    self.mix=FixedSlider(restv,restv)
    self.highv=highv

  def callback(self):
    t = getTime()
    c = math.cos(t)**2 * 0.10 + 0.25
    self.strength = c
#    t = getTime()
#    c = math.cos(t) +1
#    self.spread = FixedSlider(c,c)
#    for event in self.m_events:

 #     if getEvent(EC_NOTE_ON,event):
 #       self.mix.setTargetValue(self.highv)
#        self.mix.setFixPointDamping(0.9995)
#        self.mix.setDamping(0.97)

class SimpleGlow(Glow):
  def __init__(self,events=[],restv=0.0,highv=1.0):
    Glow.__init__(self)
    self.m_events=events
    self.mix=FixedSlider(restv,restv)
    self.highv=highv

  def callback(self):
    for event in self.m_events:
      if getEvent(EC_NOTE_ON,event):
        self.mix.setTargetValue(self.highv)
        self.mix.setFixPointDamping(0.9995)
        self.mix.setDamping(0.97)


class RandomBlur(Blur):
  def __init__(self,events=[],restv=0.0,highv=1.0):
    Blur.__init__(self)
    self.m_events=events
    self.highv=highv
    self.restv=restv
    self.mix=FixedSlider(self.restv,self.restv)


  def callback(self):
    if random.random() < 0.1:
      self.mix.setTargetValue(self.highv)


class SimpleDistort(Distort):
  def __init__(self,event=[],distVal=0):
    Distort.__init__(self)
    self.m_event=event
    self.amount=FixedSlider(distVal,distVal)


  def callback(self):
    for event in self.m_event:
      if getEvent(EC_NOTE_ON,event[1]):
        self.amount.setTargetValue(event[0])
        self.amount.setFixPointDamping(1)
        self.amount.setDamping(0.97)






class SimpleNoise(Noise):
  """ SimpleNoise renders noise 
  """


  def __init__(self,event,intensity=1.0,eventIntensity=0.0):
    Noise.__init__(self)
    self.m_event=event
    self.intensity=FixedSlider(intensity,intensity)
    self.eventIntensity=eventIntensity
  def callback(self):
    for event in self.m_event:
      if getEvent(EC_NOTE_ON,event):
        self.spread.setTargetValue(3)
        self.intensity.setTargetValue(self.eventIntensity)



class SimpleScene(Scene):
  """ 
  Simple scene renders the given scene and responds to events defined in nextCamera and reset.
  """

  def __init__(self,sceneName,nextCamera=[],reset=[],cameraOrder=[],offsets=[],curveEvents=[],noiseEvents=[],speeds=[],defaultspeed=8000,transforms=[],colors=[],curveWidth=5, loop=False):
    Scene.__init__(self)
    self.sceneProxy=SceneProxy(sceneName)
    self.setScene(self.sceneProxy)
    if cameraOrder==[]:cameraOrder=range(self.getNumCameras())
    self.cameraOrder=cameraOrder
    self.nextCameraEvents=nextCamera
    self.resetEvents=reset
    self.speed=FixedSlider(defaultspeed,defaultspeed)
    self.curveWidth=curveWidth
    self.callBacks = []


    self.curCam=0
    self.setCamera(cameraOrder[0])
    self.offsetEvents=offsets
    self.speedEvents=speeds

    self.curveEvents=curveEvents
    self.noiseEvents=noiseEvents

    self.transformEvents=transforms
    self.colorEvents=colors
    self.loop = loop

    meshes=self.getScene().getObjects()
    for transform in self.transformEvents:
      meshes[transform[0]].addTransform(transform[1])

  def callback(self):
    t= getTime()
    c = math.cos(t) * 0.4 + 0.5  + random.random()*0.1
#    s = math.sin(t) * 0.5 + 0.5
    self.getScene().getMaterials()[1].glow = c
    self.getScene().getMaterials()[3].glow = c
#    self.getScene().getMaterials()[2].glow = s
    
    
    if self.loop:
      if self.cameraAnimEnded():
        self.reset()
        
    for nc in self.nextCameraEvents:
      if getEvent(EC_NOTE_ON,nc):
        self.nextCamera()
        #self.curCam=self.curCam+1
        #if self.curCam==len(self.cameraOrder): self.curCam=0
        #elf.setCamera(self.cameraOrder[self.curCam])


    for rc in self.resetEvents:
      if getEvent(EC_NOTE_ON,rc):
        self.reset()

    for offset in self.offsetEvents:
      if getEvent(EC_NOTE_ON,offset[1]):
        self.offset.setTargetValue(offset[0])

    for speed in self.speedEvents:
      if getEvent(EC_NOTE_ON,speed[1]):
        self.speed.setMode(1)
        self.speed.setDamping(6000)
        self.speed.setTargetValue(speed[0])


    for transform in self.transformEvents:
      if getEvent(EC_NOTE_ON,transform[2]):
        # HACK THIS WAS NEEDED FOR POLAR BEAR ALERT
        if frand(0,4) < 1 :
          scale=frand(2,3)
          transform[1].x.setTargetValue(scale)
          transform[1].y.setTargetValue(scale)
          transform[1].z.setTargetValue(scale)


#process curves
    if len(self.curveEvents)>0: #hack
      meshes=self.getScene().getObjects()
      for event in self.curveEvents:
        if getEvent(EC_NOTE_ON,event[1]):
          if event[0]<len(meshes):
            meshes[event[0]].curveWidth.setMode(1)
            meshes[event[0]].curveWidth.setTargetValue(frand(25,40))
            meshes[event[0]].curveLength.setMode(2)
            meshes[event[0]].curveLength.setFixPointDamping(0.99)
            meshes[event[0]].curveLength.setDamping(0.4)
            meshes[event[0]].curveLength.setTargetValue(frand(0,1))
            meshes[event[0]].curveBumpFreq.setMode(1)
            meshes[event[0]].curveBumpAmplitude.setMode(1)
            meshes[event[0]].curveBumpFreq.setTargetValue(5)
            meshes[event[0]].curveBumpAmplitude.setTargetValue(0.6)


#process perlin noise
    if len(self.noiseEvents)>0: #hack
      meshes=self.getScene().getObjects()
      for event in self.noiseEvents:
        if getEvent(EC_NOTE_ON,event[1]):
          if event[0]<len(meshes):

            meshes[event[0]].noiseAmplitude.setFixPointDamping(0.9995)
            meshes[event[0]].noiseAmplitude.setTargetValue(25)
            meshes[event[0]].noiseFreq.setTargetValue(0.02)
            meshes[event[0]].noiseFreq.setFixPoint(0.025)
            meshes[event[0]].noiseOffset.setMode(1)
            meshes[event[0]].noiseOffset.setDamping(0.01)
            meshes[event[0]].noiseOffset.setTargetValue(1000)



#process color modulation
    if len(self.colorEvents)>0: #hack

      meshes=self.getScene().getObjects()
      for event in self.colorEvents:
        if getEvent(EC_NOTE_ON,event[1]):
          if event[0]<len(meshes):
            meshes[event[0]].red.setTargetValue(0)
            meshes[event[0]].green.setTargetValue(0)
            meshes[event[0]].blue.setTargetValue(0)   

    for callBack in self.callBacks:
#     if getEvent(EC_NOTE_ON,callBack[0]):
      callBack[1](self,callBack[0])
